/***************************************************************************
*
* Copyright 2013
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#include <sstream>

#include "RendererList.h"
#include "SurfaceSetPointerFocusCommand.h"
#include "ICommandExecutor.h"
#include "InputManager.h"
#include "Scene.h"
#include "Surface.h"


ExecutionResult SurfaceSetPointerFocusCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());

    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_surfId);

    if (surface)
    {
        SeatList surfAccpSeats = surface->getAcceptedSeats();
        SeatList::iterator seat_it;
        RendererList* rList;
        RendererListConstIterator it;

        result = ExecutionSuccess;
        rList = executor->getRendererList();
        for (seat_it = surfAccpSeats.begin();
                (seat_it != surfAccpSeats.end()) && (result == ExecutionSuccess); seat_it++)
        {
            for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
            {
                InputManager* pInputManager = (*it)->getInputManager((char*)(*seat_it)->c_str());
                if (NULL != pInputManager)
                {
                    result = pInputManager->setPointerFocusOn(m_surfId) ? ExecutionSuccess : ExecutionFailed;
                }
                else
                {
                    std::string seatName((*seat_it)->c_str());
                    result = ExecutionFailed;
                    LOG_ERROR("SurfaceSetPointerFocusCommand", "obtained NULL input manager for seat :" << seatName);
                }
            }
        }
    }

    return result;
}

const std::string SurfaceSetPointerFocusCommand::getString()
{
    std::stringstream description;

    description << "SurfaceSetPointerFocusCommand("
                << "m_surfId=" << m_surfId
                << ")";
    return description.str();
}
